<?php

/*------------------------------------------------------------------------

# mod_tweetsdisplay

# ------------------------------------------------------------------------

# author    george peris

# copyright Copyright 2013 joomods.com. All Rights Reserved.

# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

# Websites: http://www.joomods.com

# Technical Support:  Forum - http://www.joomods.com/forum.html

-------------------------------------------------------------------------*/

// no direct access



defined('JPATH_BASE') or die;



jimport('joomla.form.formfield');



/**

 * Form Field class for the Joomla Framework.

 *

 * @package		Joomla.Framework

 * @subpackage	Form

 * @since		1.6

 */

class JFormFieldJSColor extends JFormField

{

	/**

	 * The form field type.

	 *

	 * @var		string

	 * @since	1.6

	 */

	protected $type = 'JSColor';



	/**

	 * Method to get the field input markup.

	 *

	 * @return	string	The field input markup.

	 * @since	1.6

	 */

	protected function getInput()

	{

		global $JElementJSColorJSWritten;

		if (!$JElementJSColorJSWritten) 

		{

                        $jsFile = dirname(__FILE__) . DS . ".." . DS . "jscolor" . DS . "jscolor.js";

                        $jsUrl = str_replace(JPATH_ROOT, JURI::root(true), $jsFile);

                        $jsUrl = str_replace(DS, "/", $jsUrl);



			$document	= JFactory::getDocument();

			$document->addScript( $jsUrl );



			$JElementJSColorJSWritten = TRUE;

		}



		// Initialize JavaScript field attributes.

		$onchange	= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';



		$class		= ' class="color {required:false}"';



		return '<input type="text" name="'.$this->name.'" id="'.$this->id.'"' .

				' value="'.htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8').'"' .

				$class.$onchange.'/>';

	}

}

